/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.CuodActions;
import com.ibm.hsc.cim.client.HSCCECCIMClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.GeneralUtil;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;

public class CuodChange
implements HMCCommands {
    private CuodActions cuodActionHandler;
    private HSCCECCIMClient hcc = null;
    private String activationKey;
    private String managedSystem;
    private String operation;
    private String resourceType;
    private String capUpgradeType;
    private Integer quantity;
    private static final String SET_ACTIVATION_KEY_OPERATION = "s";
    private static final String DISABLE_ACTIVATE_IMMEDIATE_OPERATION = "d";
    private static final String ENABLE_ACTIVATE_IMMEDIATE_OPERATION = "e";
    private static final String MANAGE_ONOFF_OPERATION = "m";
    private static final String CUOD_CHANGE = "cuod";
    private static final String ONOFF_CHANGE = "onoff";
    private CIMObjectPath cecPath;

    private void doSetActivationKeyOperation() throws RequiredParameterException, HSCException {
        this.cuodActionHandler.setActivateKey(this.activationKey);
        this.createCECPath();
        try {
            if (IDebug.enabled) {
                System.err.println("Waiting for CUoDActivate Status");
            }
            this.waitForCUoDResource("CUoDActivateStatus");
            Hashtable hashtable = this.hcc.getSystemData();
            int n = (Integer)hashtable.get("Mode");
            if (IDebug.enabled) {
                System.err.println("Mode is " + n);
            }
            if ((n & 0xFF) == 255) {
                if (IDebug.enabled) {
                    System.err.println("Waiting for CUoDResourceInitStatus");
                }
                this.waitForCUoDResource("CUoDResourceInitStatus");
            }
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
        }
    }

    private void doCPUOperations() throws RequiredParameterException, HSCException {
        if (this.capUpgradeType.equals(CUOD_CHANGE)) {
            if (this.operation.equals(ENABLE_ACTIVATE_IMMEDIATE_OPERATION)) {
                this.cuodActionHandler.activateImmedCPU(this.quantity);
                System.out.println(HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_RESOURCE_INITIALIZATION_SUCCEEDED", "CUoD Resource Initialization succeeded."));
            } else if (this.operation.equals(DISABLE_ACTIVATE_IMMEDIATE_OPERATION)) {
                this.cuodActionHandler.disableActivateImmedCPU();
            }
        } else if (this.capUpgradeType.equals(ONOFF_CHANGE) && this.operation.equals(MANAGE_ONOFF_OPERATION)) {
            Hashtable hashtable = this.cuodActionHandler.onoffProcessorInfo();
            if (!this.validateOnOffInfo(hashtable, this.quantity)) {
                return;
            }
            this.cuodActionHandler.manageOnOffCoDProcessors(this.quantity);
        }
    }

    private void doMemoryOperations() throws RequiredParameterException, HSCException {
        if (this.operation.equals(ENABLE_ACTIVATE_IMMEDIATE_OPERATION)) {
            this.cuodActionHandler.activateImmedMemory(this.quantity);
            System.out.println(HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_RESOURCE_INITIALIZATION_SUCCEEDED", "CUoD Resource Initialization succeeded."));
        } else if (this.operation.equals(DISABLE_ACTIVATE_IMMEDIATE_OPERATION)) {
            this.cuodActionHandler.disableActivateImmedMem();
        }
    }

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        this.hcc = (HSCCECCIMClient)hSCClientObjectFactory.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
            throw new HSCException(string);
        }
        this.cuodActionHandler = this.hcc.getCuodActionHandler();
    }

    private void checkRequiredParameters() throws RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (null == this.managedSystem || null == this.capUpgradeType || null == this.operation) {
            String string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null);
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + " " + string3 + " " + HMCCommandUtils.OPERATION_PARAM + string3 + " " + HMCCommandUtils.CAPACITY_UPGRADE_TYPE_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + " and " + HMCCommandUtils.OPERATION_PARAM + " and " + HMCCommandUtils.CAPACITY_UPGRADE_TYPE_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.operation.equals(SET_ACTIVATION_KEY_OPERATION)) {
            if (null == this.activationKey) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.ACTIVATION_KEY_PARAM};
                string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", and " + HMCCommandUtils.ACTIVATION_KEY_PARAM + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        } else if (this.operation.equals(ENABLE_ACTIVATE_IMMEDIATE_OPERATION) || this.operation.equals(DISABLE_ACTIVATE_IMMEDIATE_OPERATION)) {
            if (null == this.resourceType || null == this.quantity) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HMCCommandUtils.QUANTITY_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
                string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.QUANTITY_PARAM + ", and " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        } else if (this.operation.equals(MANAGE_ONOFF_OPERATION) && (null == this.resourceType || null == this.quantity)) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HMCCommandUtils.QUANTITY_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.QUANTITY_PARAM + ", and " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (!this.capUpgradeType.equals(CUOD_CHANGE) && !this.capUpgradeType.equals(ONOFF_CHANGE)) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HMCCommandUtils.QUANTITY_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.QUANTITY_PARAM + ", and " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType != null && !this.resourceType.equals(HMCCommandUtils.CPU_TYPE) && !this.resourceType.equals(HMCCommandUtils.MEMORY_TYPE)) {
            objectArray = new String[]{HMCCommandUtils.CPU_TYPE + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.MEMORY_TYPE};
            string = "The command entered contains an invalid resource type. The valid resource types are " + HMCCommandUtils.CPU_TYPE + ", and " + HMCCommandUtils.MEMORY_TYPE + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_INVALID_RESOURCE_TYPE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (!(this.operation == null || this.operation.equals(DISABLE_ACTIVATE_IMMEDIATE_OPERATION) || this.operation.equals(ENABLE_ACTIVATE_IMMEDIATE_OPERATION) || this.operation.equals(SET_ACTIVATION_KEY_OPERATION) || this.operation.equals(MANAGE_ONOFF_OPERATION))) {
            objectArray = new String[]{"e, d m " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + SET_ACTIVATION_KEY_OPERATION};
            string = "The command entered contains an invalid operation. The valid operations are e, d, m, and s. Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_INVALID_OPERATION", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.initializeClients();
        this.validateParameterValues();
        if (this.operation.equals(SET_ACTIVATION_KEY_OPERATION)) {
            this.doSetActivationKeyOperation();
        } else if (this.operation.equals(DISABLE_ACTIVATE_IMMEDIATE_OPERATION) || this.operation.equals(ENABLE_ACTIVATE_IMMEDIATE_OPERATION) || this.operation.equals(MANAGE_ONOFF_OPERATION)) {
            if (this.resourceType.equals(HMCCommandUtils.CPU_TYPE)) {
                this.doCPUOperations();
            } else if (this.resourceType.equals(HMCCommandUtils.MEMORY_TYPE)) {
                this.doMemoryOperations();
            }
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        Object var2_2 = null;
        this.activationKey = (String)hashMap.get(HMCCommandUtils.ACTIVATION_KEY_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.operation = (String)hashMap.get(HMCCommandUtils.OPERATION_PARAM);
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        this.capUpgradeType = (String)hashMap.get(HMCCommandUtils.CAPACITY_UPGRADE_TYPE_PARAM);
        String string = (String)hashMap.get(HMCCommandUtils.QUANTITY_PARAM);
        if (string != null) {
            this.quantity = new Integer(string);
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CUOD_CHANGE_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        CuodChange cuodChange = new CuodChange();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                cuodChange.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    cuodChange.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                cuodChange.mapParameters(hashMap);
                cuodChange.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            if ((string = exception.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            if ((string = throwable.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        System.exit(0);
    }

    private boolean validateOnOffInfo(Hashtable hashtable, int n) throws HSCException {
        int n2;
        int n3 = GeneralUtil.getIntValue((String)hashtable.get("ONOFF_HOURS_REMAINING"));
        int n4 = n3 + (n2 = GeneralUtil.getIntValue((String)hashtable.get("ONOFF_DAYS_REMAINING"))) * 24;
        if (n4 <= 0) {
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "ONOFF_NO_PROCESSOR_HOURS_LEFT_ERROR");
            System.out.println("ERROR --> " + string);
            return false;
        }
        int n5 = GeneralUtil.getIntValue((String)hashtable.get("ONOFF_TOTAL_INSTALLED"));
        int n6 = GeneralUtil.getIntValue((String)hashtable.get("ONOFF_PROCS_PERM_IN_USE"));
        int n7 = GeneralUtil.getIntValue((String)hashtable.get("ONOFF_PROCS_IMMED_IN_USE"));
        int n8 = GeneralUtil.getIntValue((String)hashtable.get("ONOFF_PROCS_INCREMENT"));
        int n9 = GeneralUtil.getIntValue((String)hashtable.get("ONOFF_PROCS_GARDED"));
        int n10 = n5 - n9 - n6 - n7;
        int n11 = GeneralUtil.getIntValue((String)hashtable.get("ONOFF_PROCS_PENDING"));
        if (n10 < n) {
            String string = this.getMessage("ONOFF_PROCS_NOT_ENOUGH_ERROR");
            System.out.println("ERROR --> " + string);
            return false;
        }
        if (n11 == n) {
            String string = this.getMessage("ONOFF_COMMAND_NO_PROCESSORS_CHANGED");
            System.out.println("ERROR --> " + string);
            return false;
        }
        if (n11 < n) {
            if (n10 == 0) {
                String string = HSCResourceBundleUtil.getMessage("CECBundle", "ONOFF_PROCS_NOT_AVAILABLE_ERROR", "On/Off Processors not available");
                System.out.println("ERROR --> " + string);
                return false;
            }
        } else {
            Hashtable hashtable2 = this.hcc.getSystemData();
            int n12 = (Integer)hashtable2.get("Mode");
            if ((n12 & 0xFF) == 255) {
                int n13 = this.getUnconfiguredProcessors();
                if (n13 < 0) {
                    String string = this.getMessage("ONOFF_NO_UNCONFIGURED_PROCESSORS");
                    System.out.println("ERROR --> " + string);
                    return false;
                }
                if (n13 < n11 - n) {
                    String string = this.getMessage("ONOFF_NO_UNCONFIGURED_PROCESSORS");
                    System.out.println("ERROR --> " + string);
                    return false;
                }
            }
        }
        return true;
    }

    private int getUnconfiguredProcessors() throws HSCException {
        Vector vector = this.hcc.getPartitionClients();
        Enumeration enumeration = vector.elements();
        HSCLPARClient hSCLPARClient = (HSCLPARClient)enumeration.nextElement();
        Hashtable hashtable = hSCLPARClient.getProcessorData();
        Short s = (Short)hashtable.get("freeCpus");
        return s.shortValue();
    }

    private String getMessage(String string) {
        return HSCResourceBundleUtil.getMessage("CECBundle", string);
    }

    private void createCECPath() {
        String string = this.hcc.getHostName();
        String string2 = this.hcc.getIntName();
        this.cecPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
        this.cecPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        this.cecPath.addKey("Name", new CIMValue((Object)string2));
    }

    private void waitForCUoDResource(String string) throws Throwable {
        int n = 0;
        String string2 = this.hcc.getHostName();
        String string3 = this.hcc.getIntName();
        int n2 = 0;
        while (n2 < 500) {
            n = Integer.parseInt((String)HscUtil.getCIMAttribute(string2, this.cecPath, string).getValue());
            if (n != 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                String string4 = "Thread sleeping waiting for CUoD Resource  " + string + "caught InterruptedException";
                System.out.println(string4);
                throw new HSCException(string4);
            }
            ++n2;
        }
    }
}

